# IAFluence Dashboard — Pack de Hospedagem

Dashboard de análise de presença de marca nos modelos de IA (ChatGPT, Claude, Gemini, DeepSeek).  
Desenvolvido para rodar em qualquer hospedagem PHP simples — **sem banco de dados, sem build, sem Node.js**.

---

## Estrutura do Projeto

```
iafluence-pack/
├── index.html          # Shell HTML — estrutura fixa da dashboard
├── style.css           # Todo o CSS (light theme, paleta da marca)
├── app.js              # Motor de renderização — lê data.json e preenche o HTML
├── data.json           # 🔑 ARQUIVO DE DADOS — edite aqui para atualizar o relatório
├── assets/
│   ├── logo.svg        # Logo IAFluence
│   └── icons/
│       ├── chatgpt.png
│       ├── claude.png
│       ├── gemini.png
│       └── deepseek.png
└── README.md
```

---

## Como Atualizar o Relatório

**Você só precisa editar `data.json`.**  
Não é necessário tocar em `index.html`, `style.css` ou `app.js`.

### Estrutura do data.json

| Chave              | O que controla                                       |
|--------------------|------------------------------------------------------|
| `meta`             | Nome da marca, categoria, período, versão            |
| `scorecard`        | Índice GEO, KPIs, risco, oportunidade, síntese       |
| `brandSummary`     | Descrição da marca, tags, maturidade GEO             |
| `shareOfVoice`     | Dados do donut, tendência histórica, segmentação     |
| `providerPresence` | Taxa de cobertura por LLM (ChatGPT, Claude, etc.)    |
| `polarity`         | Sentimento por contexto temático                     |
| `sovByProvider`    | SoV detalhado por cada provedor                      |
| `archetype`        | Arquétipo dominante, palavras-chave, consistência    |
| `topicalAuthority` | Scores de autoridade por território × LLM            |
| `coOccurrence`     | Co-menção com concorrentes                           |
| `themes`           | Temas e volume de menções                            |
| `aiDescriptions`   | Descrições literais geradas por cada IA              |
| `strengths`        | Forças identificadas pelos modelos                   |
| `attentionPoints`  | Pontos de atenção identificados pelos modelos        |
| `promptMap`        | Queries e respostas (domina / aparece / ausente)     |
| `inferredSources`  | Fontes prováveis de treinamento                      |
| `roadmap`          | Plano de ação em 3 horizontes temporais              |
| `competitors`      | Dados dos 10+ concorrentes analisados                |

---

## Como Hospedar (PHP Simples)

### Requisitos
- Hospedagem compartilhada com PHP 7+ (qualquer provedor: Hostinger, Locaweb, cPanel, etc.)
- Não precisa de MySQL, Composer, npm ou qualquer dependência

### Passo a Passo

1. **Faça upload** de todos os arquivos para `public_html/` (ou subpasta) via FTP ou gerenciador de arquivos
2. **Acesse** `https://seudominio.com/` no navegador
3. **Pronto** ✓

> ⚠️ **Importante:** o `app.js` usa `fetch('data.json')`, que requer servidor HTTP.  
> Não funciona abrindo `index.html` diretamente como arquivo local (`file://`).  
> Para testes locais, use um servidor simples (ver abaixo).

### Testar Localmente (sem hospedagem)

**PHP (mais fácil — qualquer computador com PHP instalado):**
```bash
cd iafluence-pack
php -S localhost:8000
# Acesse http://localhost:8000
```

**Python:**
```bash
cd iafluence-pack
python3 -m http.server 8000
# Acesse http://localhost:8000
```

**VS Code:**
Instale a extensão "Live Server" e clique em "Go Live".

---

## Atualizar para um Novo Cliente

1. Edite `data.json`:
   - Mude `meta.brand` para o nome do novo cliente
   - Mude `meta.category`, `meta.period`
   - Atualize todos os números e textos
2. Substitua `assets/logo.svg` pelo logo do cliente (opcional)
3. Faça upload — a dashboard reflete os novos dados automaticamente

### Exemplo rápido — mudar o cliente:
```json
"meta": {
  "brand": "NomeDaEmpresa",
  "category": "Segmento · Categoria",
  "period": "Março 2025",
  "version": "1.0"
}
```

---

## Gerar Múltiplos Relatórios

Para rodar relatórios de clientes diferentes no mesmo servidor:

```
public_html/
├── cliente-a/
│   ├── index.html
│   ├── style.css
│   ├── app.js
│   ├── data.json   ← dados do cliente A
│   └── assets/
├── cliente-b/
│   ├── index.html
│   ├── style.css
│   ├── app.js
│   ├── data.json   ← dados do cliente B
│   └── assets/
```

---

## Paleta de Cores

| Variável      | Hex       | Uso                        |
|---------------|-----------|----------------------------|
| `--blue`      | `#2133FD` | Primary, CTAs, accent       |
| `--yellow`    | `#FFC700` | Destaques, badges           |
| `--navy`      | `#1A14A3` | Secondary                   |
| `--dark`      | `#011A3E` | Texto, fundos escuros       |
| `--sky`       | `#00B3FF` | Positivo, tendências up     |
| `--pink`      | `#FE368C` | Alertas médios, DeepSeek    |
| `--red`       | `#F32534` | Alertas críticos, negativo  |

---

## Dependências Externas (CDN)

O projeto carrega dois scripts externos automaticamente:

| Biblioteca | Versão  | Uso                         |
|------------|---------|-----------------------------|
| Chart.js   | 4.4.1   | Gráficos (donut, linha, bar, radar) |
| Lucide     | latest  | Ícones SVG                  |

Requer conexão com internet para carregar os ícones e gráficos.  
Para uso **100% offline**, faça download dos arquivos e ajuste os `<script src>` no `index.html`.

---

## Suporte

Dúvidas ou customizações: **contato@iafluence.com.br**  
Documentação completa: **docs.iafluence.com.br**
